<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class AllReport extends Model
{
    use HasFactory;

    protected $table = 'all_reports';  // Assuming this is the table name, adjust as needed.

    // Static method to get data for the last 30 days
    public static function getLast30DaysData()
    {
        // Fetching Sell Transactions data
        $sellTransactions = DB::table('sell_transactions')
            ->selectRaw('DATE(date_time) as date, SUM(sell_price) as total_sales, SUM(profit) as total_profit')
            ->where('date_time', '>=', now()->subDays(30))
            ->groupBy('date')
            ->orderBy('date', 'ASC')
            ->get()
            ->keyBy('date');  // Key by date

        // Fetching Direct Sales data
        $directSales = DB::table('direct_sales')
            ->selectRaw('DATE(direct_date_time) as date, SUM(direct_sell_price) as total_direct_sales, SUM(direct_profit) as total_direct_profit')
            ->where('direct_date_time', '>=', now()->subDays(30))
            ->groupBy('date')
            ->orderBy('date', 'ASC')
            ->get()
            ->keyBy('date');  // Key by date

        // Merge all dates from both collections (Sell Transactions and Direct Sales)
        $allDates = $sellTransactions->keys()->merge($directSales->keys())->unique()->sort();

        // Merging both collections
        $mergedData = collect();

        foreach ($allDates as $date) {
            $mergedData->push([
                'date' => $date,
                'total_sales' => $sellTransactions[$date]->total_sales ?? 0,
                'total_profit' => $sellTransactions[$date]->total_profit ?? 0,
                'total_direct_sales' => $directSales[$date]->total_direct_sales ?? 0,
                'total_direct_profit' => $directSales[$date]->total_direct_profit ?? 0,
            ]);
        }

        return $mergedData->values();
    }
}